/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entities;

import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.client.anim.TickFloat;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.entities.ai.LifeStageController;
import wolfshotz.dml.misc.DragonEggBlock;

public class DragonEggEntity
extends Entity {
    public static final float WIDTH = 0.9f;
    public static final float HEIGHT = 0.9f;
    public static final int CHECK_HABITAT_INTERVAL = 200;
    public static final int DEFAULT_HATCH_TIME = 12000;
    public static final float EGG_WIGGLE_THRESHOLD = 3000.0f;
    public static final String NBT_HATCH_TIME = "HatchTime";
    public static final String NBT_BREED = "Type";
    public static final byte HATCH_ID = 1;
    public static final byte WIGGLE_ID = 2;
    public static final DataParameter<String> EGG_TYPE = EntityDataManager.func_187226_a(DragonEggEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private final TickFloat wiggleTime = new TickFloat().setLimit(0.0f, 1.0f);
    public DragonEggBlock egg;
    private int hatchTime;
    private boolean wiggling;

    public DragonEggEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
        this.setEggType((Block)DMLRegistry.AETHER_EGG_BLOCK.get());
        this.hatchTime = 12000;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EGG_TYPE, (Object)"");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(NBT_HATCH_TIME, this.hatchTime);
        compound.func_74778_a(NBT_BREED, this.egg.getRegistryName().func_110623_a());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.hatchTime = compound.func_74762_e(NBT_HATCH_TIME);
        this.setEggType((Block)ForgeRegistries.BLOCKS.getValue(DragonMountsLegacy.rl(compound.func_74779_i(NBT_BREED))));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(EGG_TYPE)) {
            this.egg = (DragonEggBlock)ForgeRegistries.BLOCKS.getValue(DragonMountsLegacy.rl((String)this.field_70180_af.func_187225_a(EGG_TYPE)));
        }
    }

    public void setEggType(Block block) {
        if (!(block instanceof DragonEggBlock)) {
            throw new IllegalArgumentException("This damned block is not a dragon egg block. Wth are u doing?: " + block.getRegistryName());
        }
        this.field_70180_af.func_187227_b(EGG_TYPE, (Object)block.getRegistryName().func_110623_a());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public void func_70071_h_() {
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.98, 0.3));
        this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), e -> !(e instanceof PlayerEntity)).forEach(arg_0 -> ((DragonEggEntity)this).func_70108_f(arg_0));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 200 == 0) {
                this.updateHabitat();
            }
            if (--this.hatchTime <= 0) {
                this.hatch();
                return;
            }
            if ((float)this.hatchTime < 3000.0f && this.field_70146_Z.nextInt(Math.max(10, this.hatchTime)) == 0) {
                this.wiggle();
            }
        } else {
            this.wiggleTime.add(this.wiggling ? 0.1f : -0.1f);
            if (this.wiggleTime.get() == 1.0f) {
                this.wiggling = false;
            }
            double px = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5);
            double py = this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5);
            double pz = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5);
            if (this.egg == DMLRegistry.ENDER_EGG_BLOCK.get()) {
                double ox = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oy = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, px, py, pz, ox, oy, oz);
            } else {
                boolean primary = this.field_70146_Z.nextInt(3) != 0;
                float r = this.egg.getColorR(primary);
                float g = this.egg.getColorG(primary);
                float b = this.egg.getColorB(primary);
                this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(r, g, b, 1.0f), px, py + 1.0, pz, 0.0, 0.0, 0.0);
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        super.func_70097_a(source, amount);
        this.func_199703_a((IItemProvider)this.egg);
        this.func_70106_y();
        return false;
    }

    public void updateHabitat() {
        DMLRegistry.BLOCKS.getEntries().stream().filter(b -> b.get() instanceof DragonEggBlock).map(b -> (DragonEggBlock)b.get()).filter(b -> b.getHabitatPoints(this) > 2).max(Comparator.comparingInt(b -> b.getHabitatPoints(this))).ifPresent(this::setEggType);
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 1: {
                this.hatch();
                break;
            }
            case 2: {
                this.wiggle();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void hatch() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217379_c(2001, this.func_233580_cy_(), Block.func_196246_j((BlockState)this.egg.func_176223_P()));
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
            TameableDragonEntity dragon = (TameableDragonEntity)this.egg.breed.get().func_200721_a(this.field_70170_p);
            dragon.getLifeStageController().setLifeStage(LifeStageController.EnumLifeStage.HATCHLING);
            dragon.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            dragon.func_200203_b(this.func_200201_e());
            this.field_70170_p.func_217376_c((Entity)dragon);
        }
        this.func_70106_y();
    }

    public void wiggle() {
        if (this.field_70170_p.field_72995_K) {
            if (this.wiggling || this.wiggleTime.get() > 0.0f) {
                return;
            }
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.wiggling = true;
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)2);
        }
    }
}

