/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import wolfshotz.dml.DMLRegistry;

public class Loot
extends LootTableProvider {
    private static final Gson GSON = LootSerializers.func_237387_b_().registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).setPrettyPrinting().create();
    private final DataGenerator dataGen;
    private DirectoryCache cache;

    public Loot(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.dataGen = dataGeneratorIn;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLootTables(){

            protected void addTables() {
                this.getKnownBlocks().forEach(arg_0 -> (this).func_218492_c(arg_0));
            }

            protected Iterable<Block> getKnownBlocks() {
                return DMLRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toSet());
            }
        }, (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    public void func_200398_a(DirectoryCache cache) {
        super.func_200398_a(cache);
        this.cache = cache;
        this.addInjections();
    }

    public void addInjections() {
        this.inject(LootTables.field_186421_c, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.ENDER_EGG_BLOCK.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95)).func_216044_b());
        this.inject(LootTables.field_191192_o, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.GHOST_EGG_BLOCK.get())).func_216086_a(13)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(87)).func_216044_b());
        this.inject(LootTables.field_186430_l, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.FOREST_EGG_BLOCK.get())).func_216086_a(25)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(75)).func_216044_b());
        this.inject(LootTables.field_186429_k, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.FIRE_EGG_BLOCK.get())).func_216086_a(13)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(87)).func_216044_b());
        this.inject(LootTables.field_186431_m, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.ICE_EGG_BLOCK.get())).func_216086_a(20)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(80)).func_216044_b());
        this.inject(LootTables.field_186425_g, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.NETHER_EGG_BLOCK.get())).func_216086_a(8)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(92)).func_216044_b());
        this.inject(LootTables.field_204115_q, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.WATER_EGG_BLOCK.get())).func_216086_a(12)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(88)).func_216044_b());
        this.inject(LootTables.field_204312_r, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.WATER_EGG_BLOCK.get())).func_216086_a(50)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(50)).func_216044_b());
        this.inject(LootTables.field_186422_d, LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)DMLRegistry.AETHER_EGG_BLOCK.get())).func_216086_a(40)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60)).func_216044_b());
    }

    public void inject(ResourceLocation table, LootPool pool) {
        try {
            JsonObject object = new JsonObject();
            JsonArray array = new JsonArray();
            array.add(GSON.toJsonTree((Object)pool));
            object.add("pools", (JsonElement)array);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)this.cache, (JsonElement)object, (Path)this.dataGen.func_200391_b().resolve(String.format("data/dragonmounts/loot_tables/injects/%s/%s.json", table.func_110624_b(), table.func_110623_a())));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save table injection: " + table);
        }
    }
}

