/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.vector.Vector3f;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.client.model.ModelPart;
import wolfshotz.dml.client.model.ModelPartProxy;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.util.MathX;

public class DragonModel
extends EntityModel<TameableDragonEntity> {
    public static final int NECK_SIZE = 10;
    public static final int TAIL_SIZE = 10;
    public static final int VERTS_NECK = 7;
    public static final int VERTS_TAIL = 12;
    public static final int HEAD_OFS = -16;
    public ModelPart head;
    public ModelPart neck;
    public ModelPart neckScale;
    public ModelPart tail;
    public ModelPart tailHornLeft;
    public ModelPart tailHornRight;
    public ModelPart tailScaleLeft;
    public ModelPart tailScaleMiddle;
    public ModelPart tailScaleRight;
    public ModelPart jaw;
    public ModelPart body;
    public ModelPart back;
    public ModelPart foreThigh;
    public ModelPart foreCrus;
    public ModelPart foreFoot;
    public ModelPart foreToe;
    public ModelPart hindThigh;
    public ModelPart hindCrus;
    public ModelPart hindFoot;
    public ModelPart hindToe;
    public ModelPart rightWingArm;
    public ModelPart rightWingForearm;
    public ModelPart[] rightWingFingers = new ModelPart[4];
    public ModelPart leftWingArm;
    public ModelPart leftWingForearm;
    public ModelPart[] leftWingFingers = new ModelPart[4];
    public ModelPartProxy[] neckProxy = new ModelPartProxy[7];
    public ModelPartProxy[] tailProxy = new ModelPartProxy[12];
    public ModelPartProxy[] thighProxy = new ModelPartProxy[4];
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float pitch;
    public float size;
    private final EntityType<? extends TameableDragonEntity> type;

    public DragonModel(EntityType<? extends TameableDragonEntity> type) {
        super(RenderType::func_228638_b_);
        this.type = type;
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.buildBody();
        this.buildNeck();
        this.buildHead();
        this.buildTail();
        this.buildWings();
        this.buildLegs();
    }

    private void buildHead() {
        this.head = new ModelPart(this);
        this.head.addBox(-6.0f, -1.0f, -24.0f, 12, 5, 16, 56, 88);
        this.head.addBox(-8.0f, -8.0f, -10.0f, 16, 16, 16, 0, 0);
        this.head.addBox(-5.0f, -3.0f, -22.0f, 2, 2, 4, 48, 0);
        this.head.field_78809_i = true;
        this.head.addBox(3.0f, -3.0f, -22.0f, 2, 2, 4, 48, 0);
        this.buildHorn(false);
        this.buildHorn(true);
        this.jaw = this.head.addChildBox(-6.0f, 0.0f, -16.0f, 12, 4, 16, 0, 88);
        this.jaw.func_78793_a(0.0f, 4.0f, -8.0f);
    }

    private void buildHorn(boolean mirror) {
        int hornThick = 3;
        int hornLength = 12;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = -5.0f;
        float hornPosY = -8.0f;
        float hornPosZ = 0.0f;
        float hornRotX = MathX.toRadians(30.0f);
        float hornRotY = MathX.toRadians(-30.0f);
        float hornRotZ = 0.0f;
        if (mirror) {
            hornPosX *= -1.0f;
            hornRotY *= -1.0f;
        }
        this.head.field_78809_i = mirror;
        ModelPart horn = this.head.addChildBox(hornOfs, hornOfs, hornOfs, hornThick, hornThick, hornLength, 28, 32);
        horn.func_78793_a(hornPosX, hornPosY, hornPosZ);
        horn.setAngles(hornRotX, hornRotY, hornRotZ);
    }

    private void buildNeck() {
        this.neck = new ModelPart(this);
        this.neck.addBox(-5.0f, -5.0f, -5.0f, 10, 10, 10, 112, 88);
        this.neckScale = this.neck.addChildBox(-1.0f, -7.0f, -3.0f, 2, 4, 6, 0, 0);
        for (int i = 0; i < this.neckProxy.length; ++i) {
            this.neckProxy[i] = new ModelPartProxy(this.neck);
        }
    }

    private void buildTail() {
        this.tail = new ModelPart(this);
        this.tail.addBox(-5.0f, -5.0f, -5.0f, 10, 10, 10, 152, 88);
        float scaleRotZ = MathX.toRadians(45.0f);
        this.tailScaleLeft = this.tail.addChildBox(-1.0f, -8.0f, -3.0f, 2, 4, 6, 0, 0).setAngles(0.0f, 0.0f, scaleRotZ);
        this.tailScaleMiddle = this.tail.addChildBox(-1.0f, -8.0f, -3.0f, 2, 4, 6, 0, 0).setAngles(0.0f, 0.0f, 0.0f);
        this.tailScaleRight = this.tail.addChildBox(-1.0f, -8.0f, -3.0f, 2, 4, 6, 0, 0).setAngles(0.0f, 0.0f, -scaleRotZ);
        boolean show = this.type == DMLRegistry.FIRE_DRAGON_ENTITY.get();
        this.tailScaleMiddle.field_78806_j = !show;
        this.tailScaleLeft.field_78806_j = show;
        this.tailScaleRight.field_78806_j = show;
        this.buildTailHorn(false);
        this.buildTailHorn(true);
        for (int i = 0; i < this.tailProxy.length; ++i) {
            this.tailProxy[i] = new ModelPartProxy(this.tail);
        }
    }

    private void buildTailHorn(boolean mirror) {
        int hornThick = 3;
        int hornLength = 32;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = 0.0f;
        float hornPosZ = 5.0f;
        float hornRotX = MathX.toRadians(-15.0f);
        float hornRotY = MathX.toRadians(-145.0f);
        float hornRotZ = 0.0f;
        if (mirror) {
            hornPosX *= -1.0f;
            hornRotY *= -1.0f;
        }
        this.tail.field_78809_i = mirror;
        ModelPart horn = this.tail.addChildBox(hornOfs, hornOfs, hornOfs, hornThick, hornThick, hornLength, 0, 117);
        horn.func_78793_a(hornPosX, hornOfs, hornPosZ);
        horn.setAngles(hornRotX, hornRotY, hornRotZ);
        boolean bl = horn.field_78806_j = this.type == DMLRegistry.WATER_DRAGON_ENTITY.get();
        if (mirror) {
            this.tailHornLeft = horn;
        } else {
            this.tailHornRight = horn;
        }
    }

    private void buildBody() {
        this.body = new ModelPart(this);
        this.body.func_78793_a(0.0f, 4.0f, 8.0f);
        this.body.addBox(-12.0f, 0.0f, -16.0f, 24, 24, 64, 0, 0);
        this.body.addBox(-1.0f, -6.0f, 10.0f, 2, 6, 12, 0, 32);
        this.body.addBox(-1.0f, -6.0f, 30.0f, 2, 6, 12, 0, 32);
        this.back = this.body.addChildBox(-1.0f, -6.0f, -10.0f, 2, 6, 12, 0, 32);
    }

    private void buildWings() {
        this.rightWingArm = new ModelPart(this);
        this.rightWingArm.func_78793_a(-10.0f, 5.0f, 4.0f);
        this.rightWingArm.setRenderScale(1.1f);
        this.rightWingArm.addBox(-28.0f, -3.0f, -3.0f, 28, 6, 6, 0, 152);
        this.rightWingArm.addBox(-28.0f, 0.0f, 2.0f, 28, 0, 24, 116, 232);
        this.rightWingForearm = new ModelPart(this);
        this.rightWingForearm.func_78793_a(-28.0f, 0.0f, 0.0f);
        this.rightWingForearm.addBox(-48.0f, -2.0f, -2.0f, 48, 4, 4, 0, 164);
        this.rightWingArm.func_78792_a(this.rightWingForearm);
        this.rightWingFingers[0] = this.buildWingFinger(false, false);
        this.rightWingFingers[1] = this.buildWingFinger(false, false);
        this.rightWingFingers[2] = this.buildWingFinger(false, false);
        this.rightWingFingers[3] = this.buildWingFinger(true, false);
        this.leftWingArm = new ModelPart(this);
        this.leftWingArm.field_78809_i = true;
        this.leftWingArm.func_78793_a(10.0f, 5.0f, 4.0f);
        this.leftWingArm.setRenderScale(1.1f);
        this.leftWingArm.addBox(0.0f, -3.0f, -3.0f, 28, 6, 6, 0, 152);
        this.leftWingArm.addBox(0.0f, 0.0f, 2.0f, 28, 0, 24, 116, 232);
        this.leftWingForearm = new ModelPart(this);
        this.leftWingForearm.field_78809_i = true;
        this.leftWingForearm.func_78793_a(28.0f, 0.0f, 0.0f);
        this.leftWingForearm.addBox(0.0f, -2.0f, -2.0f, 48, 4, 4, 0, 164);
        this.leftWingArm.func_78792_a(this.leftWingForearm);
        this.leftWingFingers[0] = this.buildWingFinger(false, true);
        this.leftWingFingers[1] = this.buildWingFinger(false, true);
        this.leftWingFingers[2] = this.buildWingFinger(false, true);
        this.leftWingFingers[3] = this.buildWingFinger(true, true);
    }

    private ModelPart buildWingFinger(boolean small, boolean left) {
        ModelPart finger = new ModelPart(this);
        if (left) {
            finger.field_78809_i = true;
            finger.func_78793_a(47.0f, 0.0f, 0.0f);
            finger.addBox(0.0f, -1.0f, -1.0f, 70, 2, 2, 0, 172);
            if (small) {
                finger.addBox(0.0f, 0.0f, 1.0f, 70, 0, 32, -32, 224);
            } else {
                finger.addBox(0.0f, 0.0f, 1.0f, 70, 0, 48, -49, 176);
            }
            this.leftWingForearm.func_78792_a(finger);
        } else {
            finger.func_78793_a(-47.0f, 0.0f, 0.0f);
            finger.addBox(-70.0f, -1.0f, -1.0f, 70, 2, 2, 0, 172);
            if (small) {
                finger.addBox(-70.0f, 0.0f, 1.0f, 70, 0, 32, -32, 224);
            } else {
                finger.addBox(-70.0f, 0.0f, 1.0f, 70, 0, 48, -49, 176);
            }
            this.rightWingForearm.func_78792_a(finger);
        }
        return finger;
    }

    private void buildLegs() {
        this.buildLeg(false);
        this.buildLeg(true);
        for (int i = 0; i < 4; ++i) {
            this.thighProxy[i] = i % 2 == 0 ? new ModelPartProxy(this.foreThigh) : new ModelPartProxy(this.hindThigh);
        }
    }

    private void buildLeg(boolean hind) {
        boolean thin = this.type == DMLRegistry.GHOST_DRAGON_ENTITY.get();
        float baseLength = 26.0f;
        int texY = hind ? 29 : 0;
        float thighPosX = -11.0f;
        float thighPosY = 18.0f;
        float thighPosZ = 4.0f;
        int thighThick = 9 - (thin ? 2 : 0);
        int thighLength = (int)(baseLength * (hind ? 0.9f : 0.77f));
        if (hind) {
            ++thighThick;
            thighPosY -= 5.0f;
        }
        float thighOfs = -((float)thighThick / 2.0f);
        ModelPart thigh = new ModelPart(this);
        thigh.func_78793_a(thighPosX, thighPosY, thighPosZ);
        thigh.addBox(thighOfs, thighOfs, thighOfs, thighThick, thighLength, thighThick, 112, texY);
        float crusPosX = 0.0f;
        float crusPosY = (float)thighLength + thighOfs;
        float crusPosZ = 0.0f;
        int crusThick = thighThick - 2;
        int crusLength = (int)(baseLength * (hind ? 0.7f : 0.8f));
        if (hind) {
            --crusThick;
            crusLength -= 2;
        }
        float crusOfs = -((float)crusThick / 2.0f);
        ModelPart crus = new ModelPart(this);
        crus.func_78793_a(crusPosX, crusPosY, crusPosZ);
        crus.addBox(crusOfs, crusOfs, crusOfs, crusThick, crusLength, crusThick, hind ? 152 : 148, texY);
        thigh.func_78792_a(crus);
        float footPosX = 0.0f;
        float footPosY = (float)crusLength + crusOfs / 2.0f;
        float footPosZ = 0.0f;
        int footWidth = crusThick + 2 + (thin ? 2 : 0);
        int footHeight = 4;
        int footLength = (int)(baseLength * (hind ? 0.67f : 0.34f));
        float footOfsX = -((float)footWidth / 2.0f);
        float footOfsY = -((float)footHeight / 2.0f);
        float footOfsZ = (float)footLength * -0.75f;
        ModelPart foot = new ModelPart(this);
        foot.func_78793_a(footPosX, footPosY, footPosZ);
        foot.addBox(footOfsX, footOfsY, footOfsZ, footWidth, footHeight, footLength, hind ? 180 : 210, texY);
        crus.func_78792_a(foot);
        int toeLength = (int)(baseLength * (hind ? 0.27f : 0.33f));
        float toePosX = 0.0f;
        float toePosY = 0.0f;
        float toePosZ = footOfsZ - footOfsY / 2.0f;
        float toeOfsX = -((float)footWidth / 2.0f);
        float toeOfsY = -((float)footHeight / 2.0f);
        float toeOfsZ = -toeLength;
        ModelPart toe = new ModelPart(this);
        toe.func_78793_a(toePosX, toePosY, toePosZ);
        toe.addBox(toeOfsX, toeOfsY, toeOfsZ, footWidth, footHeight, toeLength, hind ? 215 : 176, texY);
        foot.func_78792_a(toe);
        if (hind) {
            this.hindThigh = thigh;
            this.hindCrus = crus;
            this.hindFoot = foot;
            this.hindToe = toe;
        } else {
            this.foreThigh = thigh;
            this.foreCrus = crus;
            this.foreFoot = foot;
            this.foreToe = toe;
        }
    }

    public void setLivingAnimations(TameableDragonEntity dragon, float limbSwing, float limbSwingAmount, float partialTick) {
        dragon.animator.setPartialTicks(partialTick);
        dragon.animator.setMovement(limbSwing, limbSwingAmount * dragon.getScale());
        this.size = dragon.getScale();
    }

    public void setRotationAngles(TameableDragonEntity dragon, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        dragon.animator.setLook(netHeadYaw, headPitch);
        dragon.animator.animate(this);
    }

    public void func_225598_a_(MatrixStack ms, IVertexBuilder buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        ms.func_227860_a_();
        ms.func_227861_a_((double)this.offsetX, (double)this.offsetY, (double)this.offsetZ);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-this.pitch));
        this.renderHead(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        for (ModelPartProxy proxy : this.neckProxy) {
            proxy.render(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        }
        this.body.func_228309_a_(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        for (ModelPartProxy proxy : this.tailProxy) {
            proxy.render(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        }
        this.renderWings(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        this.renderLegs(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        ms.func_227865_b_();
    }

    protected void renderHead(MatrixStack ms, IVertexBuilder buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        float headScale = 1.4f / (this.size + 0.4f);
        this.head.setRenderScale(headScale);
        this.head.func_228309_a_(ms, buffer, packedLight, packedOverlay, r, g, b, a);
    }

    protected void renderWings(MatrixStack ms, IVertexBuilder buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        this.rightWingArm.func_228309_a_(ms, buffer, packedLight, packedOverlay, r, g, b, a);
        this.leftWingArm.func_228309_a_(ms, buffer, packedLight, packedOverlay, r, g, b, a);
    }

    protected void renderLegs(MatrixStack ms, IVertexBuilder buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        ms.func_227860_a_();
        for (int i = 0; i < this.thighProxy.length; ++i) {
            this.thighProxy[i].render(ms, buffer, packedLight, packedOverlay, r, g, b, a);
            if (i != 1) continue;
            ms.func_227861_a_(1.38, 0.0, 0.0);
        }
        ms.func_227865_b_();
    }
}

