/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client.anim;

import net.minecraft.util.math.MathHelper;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.client.anim.CircularBuffer;
import wolfshotz.dml.client.anim.TickFloat;
import wolfshotz.dml.client.model.DragonModel;
import wolfshotz.dml.client.model.ModelPart;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.util.MathX;

public class DragonAnimator {
    public TameableDragonEntity dragon;
    private float partialTicks;
    private float moveTime;
    private float moveSpeed;
    private float lookYaw;
    private float lookPitch;
    private double prevRenderYawOffset;
    private double yawAbs;
    private float animBase;
    private float cycleOfs;
    private float anim;
    private float ground;
    private float flutter;
    private float walk;
    private float sit;
    private float jaw;
    private float speed;
    private final TickFloat animTimer = new TickFloat();
    private final TickFloat groundTimer = new TickFloat(1.0f).setLimit(0.0f, 1.0f);
    private final TickFloat flutterTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private final TickFloat walkTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private final TickFloat jawTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private final TickFloat speedTimer = new TickFloat(1.0f).setLimit(0.0f, 1.0f);
    private boolean initTrails = true;
    private final CircularBuffer yTrail = new CircularBuffer(8);
    private final CircularBuffer yawTrail = new CircularBuffer(16);
    private final CircularBuffer pitchTrail = new CircularBuffer(16);
    private boolean onGround;
    private boolean openJaw;
    private boolean wingsDown;
    private final float[] wingArm = new float[3];
    private final float[] wingForearm = new float[3];
    private final float[] wingArmFlutter = new float[3];
    private final float[] wingForearmFlutter = new float[3];
    private final float[] wingArmGlide = new float[3];
    private final float[] wingForearmGlide = new float[3];
    private final float[] wingArmGround = new float[3];
    private final float[] wingForearmGround = new float[3];
    private final float[] xGround = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[][] xGroundStand = new float[][]{{0.8f, -1.5f, 1.3f, 0.0f}, {-0.3f, 1.5f, -0.2f, 0.0f}};
    private final float[][] xGroundSit = new float[][]{{0.3f, -1.8f, 1.8f, 0.0f}, {-0.8f, 1.8f, -0.9f, 0.0f}};
    private final float[][][] xGroundWalk = new float[][][]{new float[][]{{0.4f, -1.4f, 1.3f, 0.0f}, {0.1f, 1.2f, -0.5f, 0.0f}}, new float[][]{{1.2f, -1.6f, 1.3f, 0.0f}, {-0.3f, 2.1f, -0.9f, 0.6f}}, new float[][]{{0.9f, -2.1f, 1.8f, 0.6f}, {-0.7f, 1.4f, -0.2f, 0.0f}}};
    private final float[] xGroundWalk2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final float[] yGroundStand = new float[]{-0.25f, 0.25f};
    private final float[] yGroundSit = new float[]{0.1f, 0.35f};
    private final float[] yGroundWalk = new float[]{-0.1f, 0.1f};
    private float[] xAir;
    private final float[][] xAirAll = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}};
    private final float[] yAirAll = new float[]{-0.1f, 0.1f};

    public DragonAnimator(TameableDragonEntity dragon) {
        this.dragon = dragon;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public void setMovement(float moveTime, float moveSpeed) {
        this.moveTime = moveTime;
        this.moveSpeed = moveSpeed;
    }

    public void setLook(float lookYaw, float lookPitch) {
        this.lookYaw = MathX.clamp(lookYaw, -120.0f, 120.0f);
        this.lookPitch = MathX.clamp(lookPitch, -90.0f, 90.0f);
    }

    public void animate(DragonModel model) {
        boolean newWingsDown;
        this.anim = this.animTimer.get(this.partialTicks);
        this.ground = this.groundTimer.get(this.partialTicks);
        this.flutter = this.flutterTimer.get(this.partialTicks);
        this.walk = this.walkTimer.get(this.partialTicks);
        this.sit = this.sitTimer.get(this.partialTicks);
        this.jaw = this.jawTimer.get(this.partialTicks);
        this.speed = this.speedTimer.get(this.partialTicks);
        this.animBase = this.anim * (float)Math.PI * 2.0f;
        this.cycleOfs = MathX.sin(this.animBase - 1.0f) + 1.0f;
        boolean bl = newWingsDown = this.cycleOfs > 1.0f;
        if (newWingsDown && !this.wingsDown && this.flutter != 0.0f) {
            this.dragon.onWingsDown(this.speed);
        }
        this.wingsDown = newWingsDown;
        model.back.field_78806_j = !this.dragon.isSaddled();
        this.cycleOfs = (this.cycleOfs * this.cycleOfs + this.cycleOfs * 2.0f) * 0.05f;
        this.cycleOfs *= MathX.terpLinear(0.5f, 1.0f, this.flutter);
        this.cycleOfs *= MathX.terpLinear(1.0f, 0.5f, this.ground);
        model.offsetX = this.getModelOffsetX();
        model.offsetY = this.getModelOffsetY();
        model.offsetZ = this.getModelOffsetZ();
        model.pitch = this.getModelPitch();
        this.animHeadAndNeck(model);
        this.animTail(model);
        this.animWings(model);
        this.animLegs(model);
    }

    public void tick() {
        this.setOnGround(!this.dragon.isFlying());
        if (this.initTrails) {
            this.yTrail.fill((float)this.dragon.func_226278_cu_());
            this.yawTrail.fill(this.dragon.field_70761_aq);
            this.pitchTrail.fill(this.getModelPitch());
            this.initTrails = false;
        }
        if (this.dragon.func_110143_aJ() <= 0.0f) {
            this.animTimer.sync();
            this.groundTimer.sync();
            this.flutterTimer.sync();
            this.walkTimer.sync();
            this.sitTimer.sync();
            this.jawTimer.sync();
            return;
        }
        float speedMax = 0.05f;
        float speedEnt = (float)(this.dragon.func_213322_ci().field_72450_a * this.dragon.func_213322_ci().field_72450_a + this.dragon.func_213322_ci().field_72449_c * this.dragon.func_213322_ci().field_72449_c);
        float speedMulti = MathX.clamp(speedEnt / speedMax, 0.0f, 1.0f);
        float animAdd = 0.035f;
        if (!this.onGround) {
            animAdd += (1.0f - speedMulti) * animAdd;
        }
        this.animTimer.add(animAdd);
        float groundVal = this.groundTimer.get();
        if (this.onGround) {
            groundVal *= 0.95f;
            groundVal += 0.08f;
        } else {
            groundVal -= 0.1f;
        }
        this.groundTimer.set(groundVal);
        boolean flutterFlag = !this.onGround && (this.dragon.field_70124_G || this.dragon.func_213322_ci().field_72448_b > -0.1 || speedEnt < speedMax);
        this.flutterTimer.add(flutterFlag ? 0.1f : -0.1f);
        boolean walkFlag = (double)this.moveSpeed > 0.1 && !this.dragon.func_233684_eK_();
        float walkVal = 0.1f;
        this.walkTimer.add(walkFlag ? walkVal : -walkVal);
        float sitVal = this.sitTimer.get();
        sitVal += this.dragon.func_233684_eK_() ? 0.1f : -0.1f;
        this.sitTimer.set(sitVal *= 0.95f);
        boolean nearGround = this.dragon.getAltitude() < (double)(this.dragon.func_213302_cg() * 2.0f);
        boolean speedFlag = speedEnt > speedMax || this.onGround || nearGround;
        float speedValue = 0.05f;
        this.speedTimer.add(speedFlag ? speedValue : -speedValue);
        double yawDiff = (double)this.dragon.field_70761_aq - this.prevRenderYawOffset;
        this.prevRenderYawOffset = this.dragon.field_70761_aq;
        if (yawDiff < 180.0 && yawDiff > -180.0) {
            this.yawAbs += yawDiff;
        }
        this.yTrail.update((float)this.dragon.func_226278_cu_());
        this.yawTrail.update((float)this.yawAbs);
        this.pitchTrail.update(this.getModelPitch());
    }

    protected void animHeadAndNeck(DragonModel model) {
        model.neck.field_78800_c = 0.0f;
        model.neck.field_78797_d = 14.0f;
        model.neck.field_78798_e = -8.0f;
        model.neck.field_78795_f = 0.0f;
        model.neck.field_78796_g = 0.0f;
        model.neck.field_78808_h = 0.0f;
        float health = (float)this.dragon.getHealthRelative();
        for (int i = 0; i < model.neckProxy.length; ++i) {
            float vertMulti = (float)(i + 1) / (float)model.neckProxy.length;
            float baseRotX = MathX.cos((float)i * 0.45f + this.animBase) * 0.15f;
            baseRotX *= MathX.terpLinear(0.2f, 1.0f, this.flutter);
            float ofsRotX = MathX.sin(vertMulti * (float)Math.PI * 0.9f) * 0.75f;
            model.neck.field_78795_f = baseRotX *= MathX.terpLinear(1.0f, 0.2f, this.sit);
            model.neck.field_78795_f *= MathX.terpSmoothStep(1.0f, 0.5f, this.walk);
            model.neck.field_78795_f += (1.0f - this.speed) * vertMulti;
            model.neck.field_78795_f -= MathX.terpLinear(0.0f, ofsRotX, this.ground * health);
            model.neck.field_78796_g = MathX.toRadians(this.lookYaw) * vertMulti * this.speed;
            model.neck.renderScaleX = model.neck.renderScaleY = MathX.terpLinear(1.6f, 1.0f, vertMulti);
            model.neck.renderScaleZ = 0.6f;
            model.neckScale.field_78806_j = i % 2 == 0;
            model.neckProxy[i].update();
            float neckSize = 10.0f * model.neck.renderScaleZ - 1.4f;
            model.neck.field_78800_c -= MathX.sin(model.neck.field_78796_g) * MathX.cos(model.neck.field_78795_f) * neckSize;
            model.neck.field_78797_d += MathX.sin(model.neck.field_78795_f) * neckSize;
            model.neck.field_78798_e -= MathX.cos(model.neck.field_78796_g) * MathX.cos(model.neck.field_78795_f) * neckSize;
        }
        model.head.field_78795_f = MathX.toRadians(this.lookPitch) + (1.0f - this.speed);
        model.head.field_78796_g = model.neck.field_78796_g;
        model.head.field_78808_h = model.neck.field_78808_h * 0.2f;
        model.head.field_78800_c = model.neck.field_78800_c;
        model.head.field_78797_d = model.neck.field_78797_d;
        model.head.field_78798_e = model.neck.field_78798_e;
        model.jaw.field_78795_f = this.jaw * 0.75f;
        model.jaw.field_78795_f += MathHelper.func_76126_a((float)((1.0f - (1.0f - model.field_217112_c) * (1.0f - model.field_217112_c)) * (float)Math.PI));
        model.jaw.field_78795_f += (1.0f - MathX.sin(this.animBase)) * 0.1f * this.flutter;
    }

    protected void animWings(DragonModel model) {
        float aSpeed = this.sit > 0.0f ? 0.6f : 1.0f;
        float a1 = this.animBase * aSpeed * 0.35f;
        float a2 = this.animBase * aSpeed * 0.5f;
        float a3 = this.animBase * aSpeed * 0.75f;
        if (this.ground < 1.0f) {
            this.wingArmFlutter[0] = 0.125f - MathX.cos(this.animBase) * 0.2f;
            this.wingArmFlutter[1] = 0.25f;
            this.wingArmFlutter[2] = (MathX.sin(this.animBase) + 0.125f) * 0.8f;
            this.wingForearmFlutter[0] = 0.0f;
            this.wingForearmFlutter[1] = -this.wingArmFlutter[1] * 2.0f;
            this.wingForearmFlutter[2] = -(MathX.sin(this.animBase + 2.0f) + 0.5f) * 0.75f;
            this.wingArmGlide[0] = -0.25f - MathX.cos(this.animBase * 2.0f) * MathX.cos(this.animBase * 1.5f) * 0.04f;
            this.wingArmGlide[1] = 0.25f;
            this.wingArmGlide[2] = 0.35f + MathX.sin(this.animBase) * 0.05f;
            this.wingForearmGlide[0] = 0.0f;
            this.wingForearmGlide[1] = -this.wingArmGlide[1] * 2.0f;
            this.wingForearmGlide[2] = -0.25f + (MathX.sin(this.animBase + 2.0f) + 0.5f) * 0.05f;
        }
        if (this.ground > 0.0f) {
            this.wingArmGround[0] = 0.0f;
            this.wingArmGround[1] = 1.4f - MathX.sin(a1) * MathX.sin(a2) * 0.02f;
            this.wingArmGround[2] = 0.8f + MathX.sin(a2) * MathX.sin(a3) * 0.05f;
            this.wingArmGround[1] = this.wingArmGround[1] + MathX.sin(this.moveTime * 0.5f) * 0.02f * this.walk;
            this.wingArmGround[2] = this.wingArmGround[2] + MathX.cos(this.moveTime * 0.5f) * 0.05f * this.walk;
            this.wingForearmGround[0] = 0.0f;
            this.wingForearmGround[1] = -this.wingArmGround[1] * 2.0f;
            this.wingForearmGround[2] = 0.0f;
        }
        this.slerpArrays(this.wingArmGlide, this.wingArmFlutter, this.wingArm, this.flutter);
        this.slerpArrays(this.wingForearmGlide, this.wingForearmFlutter, this.wingForearm, this.flutter);
        this.slerpArrays(this.wingArm, this.wingArmGround, this.wingArm, this.ground);
        this.slerpArrays(this.wingForearm, this.wingForearmGround, this.wingForearm, this.ground);
        model.rightWingArm.field_78795_f = this.wingArm[0];
        model.rightWingArm.field_78796_g = this.wingArm[1];
        model.rightWingArm.field_78808_h = this.wingArm[2];
        model.rightWingArm.preRotateAngleX = 1.0f - this.speed;
        model.rightWingForearm.field_78795_f = this.wingForearm[0];
        model.rightWingForearm.field_78796_g = this.wingForearm[1];
        model.rightWingForearm.field_78808_h = this.wingForearm[2];
        model.leftWingArm.field_78795_f = this.wingArm[0];
        model.leftWingArm.field_78796_g = -this.wingArm[1];
        model.leftWingArm.field_78808_h = -this.wingArm[2];
        model.leftWingArm.preRotateAngleX = 1.0f - this.speed;
        model.leftWingForearm.field_78795_f = this.wingForearm[0];
        model.leftWingForearm.field_78796_g = -this.wingForearm[1];
        model.leftWingForearm.field_78808_h = -this.wingForearm[2];
        float[] yFold = new float[]{2.7f, 2.8f, 2.9f, 3.0f};
        float[] yUnfold = new float[]{0.1f, 0.9f, 1.7f, 2.5f};
        float rotX = 0.0f;
        float rotYOfs = MathX.sin(a1) * MathX.sin(a2) * 0.03f;
        float rotYMulti = 1.0f;
        for (int i = 0; i < model.rightWingFingers.length; ++i) {
            model.rightWingFingers[i].field_78795_f = rotX += 0.005f;
            model.rightWingFingers[i].field_78796_g = MathX.terpSmoothStep(yUnfold[i], yFold[i] + rotYOfs * rotYMulti, this.ground);
            model.leftWingFingers[i].field_78795_f = model.rightWingFingers[i].field_78795_f;
            model.leftWingFingers[i].field_78796_g = -model.rightWingFingers[i].field_78796_g;
            rotYMulti -= 0.2f;
        }
    }

    protected void animTail(DragonModel model) {
        model.tail.field_78800_c = 0.0f;
        model.tail.field_78797_d = 16.0f;
        model.tail.field_78798_e = 62.0f;
        model.tail.field_78795_f = 0.0f;
        model.tail.field_78796_g = 0.0f;
        model.tail.field_78808_h = 0.0f;
        float rotXStand = 0.0f;
        float rotYStand = 0.0f;
        float rotXSit = 0.0f;
        float rotYSit = 0.0f;
        float rotXAir = 0.0f;
        float rotYAir = 0.0f;
        for (int i = 0; i < model.tailProxy.length; ++i) {
            float vertMulti = (float)(i + 1) / (float)model.tailProxy.length;
            float amp = 0.1f + (float)i / ((float)model.tailProxy.length * 2.0f);
            rotXStand = ((float)i - (float)model.tailProxy.length * 0.6f) * -amp * 0.4f;
            rotXSit = (rotXStand += (MathX.sin(this.animBase * 0.2f) * MathX.sin(this.animBase * 0.37f) * 0.4f * amp - 0.1f) * (1.0f - this.sit)) * 0.8f;
            rotYStand = (rotYStand + MathX.sin((float)i * 0.45f + this.animBase * 0.5f)) * amp * 0.4f;
            rotYSit = MathX.sin(vertMulti * (float)Math.PI) * (float)Math.PI * 1.2f - 0.5f;
            model.tail.field_78795_f = MathX.terpLinear(rotXStand, rotXSit, this.sit);
            model.tail.field_78796_g = MathX.terpLinear(rotYStand, rotYSit, this.sit);
            model.tail.field_78795_f = MathX.terpLinear(rotXAir -= MathX.sin((float)i * 0.45f + this.animBase) * 0.04f * MathX.terpLinear(0.3f, 1.0f, this.flutter), model.tail.field_78795_f, this.ground);
            model.tail.field_78796_g = MathX.terpLinear(rotYAir, model.tail.field_78796_g, this.ground);
            float angleLimit = 160.0f * vertMulti;
            float yawOfs = MathX.clamp(this.yawTrail.get(this.partialTicks, 0, i + 1) * 2.0f, -angleLimit, angleLimit);
            float pitchOfs = MathX.clamp(this.pitchTrail.get(this.partialTicks, 0, i + 1) * 2.0f, -angleLimit, angleLimit);
            model.tail.field_78795_f += MathX.toRadians(pitchOfs);
            model.tail.field_78795_f -= (1.0f - this.speed) * vertMulti * 2.0f;
            model.tail.field_78796_g -= MathX.toRadians(180.0f - yawOfs);
            if (this.dragon.func_200600_R() == DMLRegistry.WATER_DRAGON_ENTITY.get()) {
                boolean horn;
                model.tailHornLeft.field_78806_j = model.tailHornRight.field_78806_j = (horn = i > model.tailProxy.length - 7 && i < model.tailProxy.length - 3);
            }
            float neckScale = MathX.terpLinear(1.5f, 0.3f, vertMulti);
            model.tail.setRenderScale(neckScale);
            model.tailProxy[i].update();
            float tailSize = 10.0f * model.tail.renderScaleZ - 0.7f;
            model.tail.field_78797_d += MathX.sin(model.tail.field_78795_f) * tailSize;
            model.tail.field_78798_e -= MathX.cos(model.tail.field_78796_g) * MathX.cos(model.tail.field_78795_f) * tailSize;
            model.tail.field_78800_c -= MathX.sin(model.tail.field_78796_g) * MathX.cos(model.tail.field_78795_f) * tailSize;
        }
    }

    protected void animLegs(DragonModel model) {
        if (this.ground < 1.0f) {
            float footAirOfs = this.cycleOfs * 0.1f;
            float footAirX = 0.75f + this.cycleOfs * 0.1f;
            this.xAirAll[0][0] = 1.3f + footAirOfs;
            this.xAirAll[0][1] = -(0.7f * this.speed + 0.1f + footAirOfs);
            this.xAirAll[0][2] = footAirX;
            this.xAirAll[0][3] = footAirX * 0.5f;
            this.xAirAll[1][0] = footAirOfs + 0.6f;
            this.xAirAll[1][1] = footAirOfs + 0.8f;
            this.xAirAll[1][2] = footAirX;
            this.xAirAll[1][3] = footAirX * 0.5f;
        }
        for (int i = 0; i < model.thighProxy.length; ++i) {
            ModelPart toe;
            ModelPart foot;
            ModelPart crus;
            ModelPart thigh;
            if (i % 2 == 0) {
                thigh = model.foreThigh;
                crus = model.foreCrus;
                foot = model.foreFoot;
                toe = model.foreToe;
                thigh.field_78798_e = 4.0f;
            } else {
                thigh = model.hindThigh;
                crus = model.hindCrus;
                foot = model.hindFoot;
                toe = model.hindToe;
                thigh.field_78798_e = 46.0f;
            }
            this.xAir = this.xAirAll[i % 2];
            this.slerpArrays(this.xGroundStand[i % 2], this.xGroundSit[i % 2], this.xGround, this.sit);
            this.xGround[3] = -(this.xGround[0] + this.xGround[1] + this.xGround[2]);
            if (this.walk > 0.0f) {
                this.splineArrays(this.moveTime * 0.2f, i > 1, this.xGroundWalk2, this.xGroundWalk[0][i % 2], this.xGroundWalk[1][i % 2], this.xGroundWalk[2][i % 2]);
                this.xGroundWalk2[3] = this.xGroundWalk2[3] - (this.xGroundWalk2[0] + this.xGroundWalk2[1] + this.xGroundWalk2[2]);
                this.slerpArrays(this.xGround, this.xGroundWalk2, this.xGround, this.walk);
            }
            float yAir = this.yAirAll[i % 2];
            float yGround = MathX.terpSmoothStep(this.yGroundStand[i % 2], this.yGroundSit[i % 2], this.sit);
            yGround = MathX.terpSmoothStep(yGround, this.yGroundWalk[i % 2], this.walk);
            thigh.field_78796_g = MathX.terpSmoothStep(yAir, yGround, this.ground) * (float)(i > 1 ? -1 : 1);
            thigh.field_78795_f = MathX.terpSmoothStep(this.xAir[0], this.xGround[0], this.ground);
            crus.field_78795_f = MathX.terpSmoothStep(this.xAir[1], this.xGround[1], this.ground);
            foot.field_78795_f = MathX.terpSmoothStep(this.xAir[2], this.xGround[2], this.ground);
            toe.field_78795_f = MathX.terpSmoothStep(this.xAir[3], this.xGround[3], this.ground);
            model.thighProxy[i].update();
        }
    }

    private void splineArrays(float x, boolean shift, float[] result, float[] ... nodes) {
        int i1 = (int)x % nodes.length;
        int i2 = (i1 + 1) % nodes.length;
        int i3 = (i1 + 2) % nodes.length;
        float[] a1 = nodes[i1];
        float[] a2 = nodes[i2];
        float[] a3 = nodes[i3];
        float xn = x % (float)nodes.length - (float)i1;
        if (shift) {
            MathX.terpCatmullRomSpline(xn, result, a2, a3, a1, a2);
        } else {
            MathX.terpCatmullRomSpline(xn, result, a1, a2, a3, a1);
        }
    }

    private void slerpArrays(float[] a, float[] b, float[] c, float x) {
        if (a.length != b.length || b.length != c.length) {
            throw new IllegalArgumentException();
        }
        if (x <= 0.0f) {
            System.arraycopy(a, 0, c, 0, a.length);
            return;
        }
        if (x >= 1.0f) {
            System.arraycopy(b, 0, c, 0, a.length);
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = MathX.terpSmoothStep(a[i], b[i], x);
        }
    }

    public float getModelPitch() {
        return this.getModelPitch(this.partialTicks);
    }

    public float getModelPitch(float pt) {
        float pitchMovingMax = 90.0f;
        float pitchMoving = MathX.clamp(this.yTrail.get(pt, 5, 0) * 10.0f, -pitchMovingMax, pitchMovingMax);
        float pitchHover = 60.0f;
        return MathX.terpSmoothStep(pitchHover, pitchMoving, this.speed);
    }

    public float getModelOffsetX() {
        return 0.0f;
    }

    public float getModelOffsetY() {
        return -1.5f + this.sit * 0.6f;
    }

    public float getModelOffsetZ() {
        return -1.5f;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public boolean isOpenJaw() {
        return this.openJaw;
    }

    public void setOpenJaw(boolean openJaw) {
        this.openJaw = openJaw;
    }
}

