/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client;

import net.minecraft.entity.EntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.client.render.DragonRenderer;
import wolfshotz.dml.client.render.EggRenderer;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.misc.LazySpawnEggItem;

public class ClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEvents::setup);
        bus.addListener(ClientEvents::itemColors);
    }

    public static void setup(FMLClientSetupEvent evt) {
        ClientEvents.registerRenders();
    }

    public static void registerRenders() {
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.AETHER_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.ENDER_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.FIRE_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.GHOST_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.FOREST_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.ICE_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.NETHER_DRAGON_ENTITY.get()));
        ClientEvents.renderer((EntityType<? extends TameableDragonEntity>)((EntityType)DMLRegistry.WATER_DRAGON_ENTITY.get()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)DMLRegistry.EGG_ENTITY.get()), EggRenderer::new);
    }

    private static void renderer(EntityType<? extends TameableDragonEntity> type) {
        RenderingRegistry.registerEntityRenderingHandler(type, rm -> new DragonRenderer(rm, type));
    }

    public static void itemColors(ColorHandlerEvent.Item evt) {
        DMLRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).filter(LazySpawnEggItem.class::isInstance).map(LazySpawnEggItem.class::cast).forEach(item -> evt.getItemColors().func_199877_a((s, index) -> item.getColor(index), new IItemProvider[]{item}));
    }
}

