/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.client.BreathKeybind;
import wolfshotz.dml.client.ClientEvents;
import wolfshotz.dml.cmd.DragonSetAgeCommand;
import wolfshotz.dml.data.DataHandler;
import wolfshotz.dml.misc.DragonEggBlock;

@Mod(value="dragonmounts")
public class DragonMountsLegacy {
    public static final String MOD_ID = "dragonmounts";
    public static final SimpleChannel NETWORK = DragonMountsLegacy.buildChannel();
    public static final Logger LOG = LogManager.getLogger((String)"dragonmounts");

    public DragonMountsLegacy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(DataHandler::gather);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::init);
        MinecraftForge.EVENT_BUS.addListener(this::startingServer);
        MinecraftForge.EVENT_BUS.addListener(this::injectLootTables);
        MinecraftForge.EVENT_BUS.addListener(DragonEggBlock::onVanillaEggActivate);
        DMLRegistry.BLOCKS.register(bus);
        DMLRegistry.ITEMS.register(bus);
        DMLRegistry.ENTITIES.register(bus);
        DMLRegistry.SOUNDS.register(bus);
    }

    public void setup(FMLCommonSetupEvent evt) {
        DeferredWorkQueue.runLater(DMLRegistry::registerEntityAttributes);
    }

    public void startingServer(FMLServerStartingEvent evt) {
        evt.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).then(DragonSetAgeCommand.register()));
    }

    public void injectLootTables(LootTableLoadEvent evt) {
        ResourceLocation name = evt.getName();
        String path = name.func_110623_a();
        if (!path.contains("chests/")) {
            return;
        }
        switch (path.replace("chests/", "")) {
            case "buried_treasure": 
            case "desert_pyramid": 
            case "end_city_treasure": 
            case "igloo_chest": 
            case "jungle_temple": 
            case "nether_bridge": 
            case "simple_dungeon": 
            case "underwater_ruin_big": 
            case "woodland_mansion": {
                break;
            }
            default: {
                return;
            }
        }
        ResourceLocation inject = DragonMountsLegacy.rl(String.format("injects/%s/%s", name.func_110624_b(), name.func_110623_a()));
        evt.getTable().addPool(LootPool.func_216096_a().name("dragonmounts_injects").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)inject).func_216086_a(1)).func_216044_b());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static SimpleChannel buildChannel() {
        String PROTOCOL_VER = "1.0";
        SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)DragonMountsLegacy.rl("network")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
        channel.registerMessage(1, BreathKeybind.Packet.class, BreathKeybind.Packet::encode, BreathKeybind.Packet::new, BreathKeybind.Packet::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        return channel;
    }
}

