/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.entities.AetherDragonEntity;
import wolfshotz.dml.entities.DragonEggEntity;
import wolfshotz.dml.entities.EndDragonEntity;
import wolfshotz.dml.entities.FireDragonEntity;
import wolfshotz.dml.entities.ForestDragonEntity;
import wolfshotz.dml.entities.GhostDragonEntity;
import wolfshotz.dml.entities.IceDragonEntity;
import wolfshotz.dml.entities.NetherDragonEntity;
import wolfshotz.dml.entities.TameableDragonEntity;
import wolfshotz.dml.entities.WaterDragonEntity;
import wolfshotz.dml.misc.DragonEggBlock;
import wolfshotz.dml.misc.LazySpawnEggItem;

public class DMLRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"dragonmounts");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dragonmounts");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dragonmounts");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"dragonmounts");
    public static final RegistryObject<EntityType<TameableDragonEntity>> AETHER_DRAGON_ENTITY = DMLRegistry.dragonEntity("aether_dragon", AetherDragonEntity::new, AetherDragonEntity::getHabitatPoints, 1169104, 0xFFFF00);
    public static final RegistryObject<EntityType<TameableDragonEntity>> ENDER_DRAGON_ENTITY = DMLRegistry.dragonEntity("ender_dragon", EndDragonEntity::new, EndDragonEntity::getHabitatPoints, 0x161616, 16737256);
    public static final RegistryObject<EntityType<TameableDragonEntity>> FIRE_DRAGON_ENTITY = DMLRegistry.dragonEntity("fire_dragon", FireDragonEntity::new, FireDragonEntity::getHabitatPoints, 9511936, 16750617, EntityType.Builder::func_220320_c);
    public static final RegistryObject<EntityType<TameableDragonEntity>> FOREST_DRAGON_ENTITY = DMLRegistry.dragonEntity("forest_dragon", ForestDragonEntity::new, ForestDragonEntity::getHabitatPoints, 346624, 693760);
    public static final RegistryObject<EntityType<TameableDragonEntity>> GHOST_DRAGON_ENTITY = DMLRegistry.dragonEntity("ghost_dragon", GhostDragonEntity::new, GhostDragonEntity::getHabitatPoints, 0xC4C4C4, 12777727);
    public static final RegistryObject<EntityType<TameableDragonEntity>> ICE_DRAGON_ENTITY = DMLRegistry.dragonEntity("ice_dragon", IceDragonEntity::new, IceDragonEntity::getHabitatPoints, 0xFFFFFF, 47103);
    public static final RegistryObject<EntityType<TameableDragonEntity>> NETHER_DRAGON_ENTITY = DMLRegistry.dragonEntity("nether_dragon", NetherDragonEntity::new, NetherDragonEntity::getHabitatPoints, 9511936, 3017472, EntityType.Builder::func_220320_c);
    public static final RegistryObject<EntityType<TameableDragonEntity>> WATER_DRAGON_ENTITY = DMLRegistry.dragonEntity("water_dragon", WaterDragonEntity::new, WaterDragonEntity::getHabitatPoints, 25343, 0x5999FF);
    public static final RegistryObject<Block> AETHER_EGG_BLOCK = DMLRegistry.block("aether_dragon_egg");
    public static final RegistryObject<EntityType<DragonEggEntity>> EGG_ENTITY = DMLRegistry.entity("egg", DragonEggEntity::new, EntityClassification.MISC, b -> b.func_220321_a(0.9f, 0.9f).setShouldReceiveVelocityUpdates(true).setUpdateInterval(20).setTrackingRange(10).func_200705_b().func_220320_c().func_206830_a("dragonmounts:egg"));
    public static final RegistryObject<Block> ENDER_EGG_BLOCK = DMLRegistry.block("ender_dragon_egg");
    public static final RegistryObject<Block> FIRE_EGG_BLOCK = DMLRegistry.block("fire_dragon_egg");
    public static final RegistryObject<Block> FOREST_EGG_BLOCK = DMLRegistry.block("forest_dragon_egg");
    public static final RegistryObject<Block> GHOST_EGG_BLOCK = DMLRegistry.block("ghost_dragon_egg");
    public static final RegistryObject<Block> ICE_EGG_BLOCK = DMLRegistry.block("ice_dragon_egg");
    public static final RegistryObject<Block> NETHER_EGG_BLOCK = DMLRegistry.block("nether_dragon_egg");
    public static final RegistryObject<Block> WATER_EGG_BLOCK = DMLRegistry.block("water_dragon_egg");
    public static final RegistryObject<SoundEvent> DRAGON_BREATHE_SOUND = DMLRegistry.sound("dragon.breathe");
    public static final RegistryObject<SoundEvent> DRAGON_STEP_SOUND = DMLRegistry.sound("dragon.step");
    public static final RegistryObject<SoundEvent> DRAGON_DEATH_SOUND = DMLRegistry.sound("dragon.death");

    private static <T extends Entity> RegistryObject<EntityType<T>> entity(String name, EntityType.IFactory<T> factory, EntityClassification classification, Consumer<EntityType.Builder<T>> builderConsumer) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builderConsumer.accept(builder);
        return ENTITIES.register(name, () -> builder.func_206830_a("dragonmounts:" + name));
    }

    private static <T extends TameableDragonEntity> RegistryObject<EntityType<T>> dragonEntity(String name, EntityType.IFactory<T> factory, ToIntFunction<DragonEggEntity> habitatFunc, int primColor, int secColor, Consumer<EntityType.Builder<T>> builderConsumer) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE);
        builder.setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setTrackingRange(80).func_220321_a(2.75f, 2.75f);
        builderConsumer.accept(builder);
        RegistryObject delegate = ENTITIES.register(name, () -> builder.func_206830_a("dragonmounts:" + name));
        DMLRegistry.block(name + "_egg", () -> new DragonEggBlock(() -> ((RegistryObject)delegate).get(), habitatFunc, primColor, secColor));
        ITEMS.register(name + "_spawn_egg", () -> new LazySpawnEggItem(() -> ((RegistryObject)delegate).get(), primColor, secColor));
        return delegate;
    }

    private static <T extends TameableDragonEntity> RegistryObject<EntityType<T>> dragonEntity(String name, EntityType.IFactory<T> factory, ToIntFunction<DragonEggEntity> habitatFunc, int primColor, int secColor) {
        return DMLRegistry.dragonEntity(name, factory, habitatFunc, primColor, secColor, t -> {});
    }

    private static RegistryObject<Block> block(String name, Supplier<Block> sup) {
        RegistryObject delegate = BLOCKS.register(name, sup);
        ITEMS.register(name, () -> new BlockItem((Block)delegate.get(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return delegate;
    }

    private static RegistryObject<Block> block(String name) {
        return RegistryObject.of((ResourceLocation)DragonMountsLegacy.rl(name), (IForgeRegistry)ForgeRegistries.BLOCKS);
    }

    private static RegistryObject<SoundEvent> sound(String name) {
        String registryName = "entity." + name;
        return SOUNDS.register(registryName, () -> new SoundEvent(DragonMountsLegacy.rl(registryName)));
    }

    public static void registerEntityAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AETHER_DRAGON_ENTITY.get()), (AttributeModifierMap)AetherDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)ENDER_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)FIRE_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)FOREST_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)GHOST_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)ICE_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)NETHER_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)WATER_DRAGON_ENTITY.get()), (AttributeModifierMap)TameableDragonEntity.getAttributes().func_233813_a_());
    }
}

