/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.render;

import info.u_team.u_team_core.gui.render.ScalingTextRender;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class ScrollingTextRender
extends ScalingTextRender {
    protected int width = 100;
    protected float stepSize = 1.0f;
    protected int speedTime = 20;
    protected int waitTime = 4000;
    protected float moveDifference = 0.0f;
    protected long lastTime = 0L;
    protected State state = State.WAITING;

    public ScrollingTextRender(Supplier<FontRenderer> fontRenderSupplier, Supplier<String> textSupplier) {
        super(fontRenderSupplier, textSupplier);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setSpeedTime(int speedtime) {
        this.speedTime = speedtime;
    }

    public int getSpeedTime() {
        return this.speedTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    @Override
    protected void updatedText() {
        this.state = State.WAITING;
        this.moveDifference = 0.0f;
        this.lastTime = 0L;
    }

    @Override
    public void draw(float x, float y) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.field_195558_d;
        double scaleFactor = window.func_198100_s();
        int nativeX = MathHelper.func_76143_f((double)((double)x * scaleFactor));
        int nativeY = MathHelper.func_76143_f((double)((double)y * scaleFactor));
        int nativeWidth = MathHelper.func_76143_f((double)((double)this.width * scaleFactor));
        ((FontRenderer)this.fontRenderSupplier.get()).getClass();
        int nativeHeight = MathHelper.func_76143_f((double)((double)((float)(9 + 1) * this.scale) * scaleFactor));
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)nativeX, (int)(window.func_198083_n() - (nativeY + nativeHeight)), (int)nativeWidth, (int)nativeHeight);
        super.draw(this.getMovingX(x), y + 2.0f);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    protected float getMovingX(float x) {
        float textWidth = this.getTextWidth();
        if ((float)this.width < textWidth) {
            float maxMove = (float)this.width - textWidth;
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            if (this.state == State.WAITING) {
                if (this.hasWaitTimePassed()) {
                    this.state = this.moveDifference >= 0.0f ? State.LEFT : State.RIGHT;
                    this.lastTime = 0L;
                }
            } else if (this.hasSpeedTimePassed()) {
                if (this.state == State.LEFT ? this.moveDifference >= maxMove : this.moveDifference <= 0.0f) {
                    this.moveDifference += this.state == State.LEFT ? -this.stepSize : this.stepSize;
                } else {
                    this.state = State.WAITING;
                }
                this.lastTime = 0L;
            }
            return x + this.moveDifference;
        }
        return x;
    }

    protected boolean hasWaitTimePassed() {
        return System.currentTimeMillis() - (long)this.waitTime >= this.lastTime;
    }

    protected boolean hasSpeedTimePassed() {
        return System.currentTimeMillis() - (long)this.speedTime >= this.lastTime;
    }

    private static enum State {
        WAITING,
        LEFT,
        RIGHT;

    }
}

