/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.data.DirectoryCache;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class CommonTagsProvider<T extends IForgeRegistryEntry<T>>
extends CommonProvider {
    protected final IForgeRegistry<T> registry;
    protected final Map<Tag<T>, Tag.Builder<T>> tagToBuilder = Maps.newLinkedHashMap();

    protected CommonTagsProvider(GenerationData data, IForgeRegistry<T> registry) {
        super(data);
        this.registry = registry;
    }

    protected abstract void registerTags();

    public void func_200398_a(DirectoryCache cache) {
        this.tagToBuilder.clear();
        this.registerTags();
        TagCollection collection = new TagCollection(id -> Optional.empty(), "", false, "generated");
        Map<ResourceLocation, Tag.Builder> map = this.tagToBuilder.entrySet().stream().collect(Collectors.toMap(entry -> ((Tag)entry.getKey()).func_199886_b(), Map.Entry::getValue));
        collection.func_219779_a(map);
        collection.func_200039_c().forEach((location, tag) -> {
            JsonObject object = tag.func_200571_a(arg_0 -> this.registry.getKey(arg_0));
            Path path = this.makePath((ResourceLocation)location);
            try {
                CommonTagsProvider.write(cache, (JsonElement)object, path);
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
        this.setCollection(collection);
    }

    protected abstract void setCollection(TagCollection<T> var1);

    protected abstract Path makePath(ResourceLocation var1);

    protected Tag.Builder<T> getBuilder(Tag<T> tag) {
        return this.tagToBuilder.computeIfAbsent(tag, otherTag -> Tag.Builder.func_200047_a());
    }
}

