/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DirectoryCache;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.world.biome.Biome;

public abstract class CommonLanguagesProvider
extends CommonProvider {
    protected final Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();

    public CommonLanguagesProvider(GenerationData data) {
        super(data);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addTranslations();
        this.data.forEach((locale, map) -> {
            if (!map.isEmpty()) {
                try {
                    CommonLanguagesProvider.write(cache, GSON.toJsonTree(map), this.resolveModAssets().resolve("lang").resolve(locale + ".json"));
                }
                catch (IOException ex) {
                    LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
                }
            }
        });
    }

    public abstract void addTranslations();

    public String func_200397_b() {
        return "Languages";
    }

    protected void add(ItemGroup key, String name) {
        this.add(key.func_78024_c(), name);
    }

    protected void addBlock(Supplier<Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.func_149739_a(), name);
    }

    protected void addItem(Supplier<Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.func_77658_a(), name);
    }

    protected void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.func_77977_a(), name);
    }

    protected void addEnchantment(Supplier<Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.func_77320_a(), name);
    }

    protected void addBiome(Supplier<Biome> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Biome key, String name) {
        this.add(key.func_210773_k(), name);
    }

    protected void addEffect(Supplier<Effect> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Effect key, String name) {
        this.add(key.func_76393_a(), name);
    }

    protected void addEntityType(Supplier<EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.func_210760_d(), name);
    }

    protected void add(String key, String value) {
        this.add("en_us", key, value);
    }

    protected void add(String locale, ItemGroup key, String name) {
        this.add(locale, key.func_78024_c(), name);
    }

    protected void addBlock(String locale, Supplier<Block> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Block key, String name) {
        this.add(locale, key.func_149739_a(), name);
    }

    protected void addItem(String locale, Supplier<Item> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Item key, String name) {
        this.add(locale, key.func_77658_a(), name);
    }

    protected void addItemStack(String locale, Supplier<ItemStack> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, ItemStack key, String name) {
        this.add(locale, key.func_77977_a(), name);
    }

    protected void addEnchantment(String locale, Supplier<Enchantment> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Enchantment key, String name) {
        this.add(locale, key.func_77320_a(), name);
    }

    protected void addBiome(String locale, Supplier<Biome> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Biome key, String name) {
        this.add(locale, key.func_210773_k(), name);
    }

    protected void addEffect(String locale, Supplier<Effect> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Effect key, String name) {
        this.add(locale, key.func_76393_a(), name);
    }

    protected void addEntityType(String locale, Supplier<EntityType<?>> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, EntityType<?> key, String name) {
        this.add(locale, key.func_210760_d(), name);
    }

    protected void add(String locale, String key, String value) {
        Map map = this.data.computeIfAbsent(locale, unused -> new TreeMap());
        if (map.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

