/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.color.ColorGetter;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public IFocus<?> translateFocus(IFocus<ItemStack> focus, IFocusFactory focusFactory) {
        IFluidBlock fluidBlock;
        Fluid fluid;
        Block block;
        ItemStack itemStack = focus.getValue();
        Item item = itemStack.func_77973_b();
        if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof IFluidBlock && (fluid = (fluidBlock = (IFluidBlock)block).getFluid()) != null) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            return focusFactory.createFocus(focus.getMode(), fluidStack);
        }
        return focus;
    }

    @Override
    @Nullable
    public ItemStack getMatch(Iterable<ItemStack> ingredients, ItemStack toMatch) {
        for (ItemStack stack : ingredients) {
            if (!this.stackHelper.isEquivalent(toMatch, stack)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        ITextComponent displayNameTextComponent = ingredient.func_200301_q();
        ErrorUtil.checkNotNull(displayNameTextComponent, "itemStack.getDisplayName()");
        return displayNameTextComponent.getString();
    }

    @Override
    public String getUniqueId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, StackHelper.UidMode.WILDCARD);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        String modId = item.getCreatorModId(ingredient);
        if (modId == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getCreatorModId() returned null for: " + stackInfo);
        }
        return modId;
    }

    @Override
    public Iterable<Integer> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getResourceId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110623_a();
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.func_77946_l();
    }

    @Override
    public ItemStack normalizeIngredient(ItemStack ingredient) {
        ItemStack copy = ingredient.func_77946_l();
        copy.func_190920_e(1);
        return copy;
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.func_190926_b();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    @Override
    public Collection<ResourceLocation> getTags(ItemStack ingredient) {
        TagCollection collection = ItemTags.func_199903_a();
        return collection.func_199913_a((Object)ingredient.func_77973_b());
    }

    @Override
    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        Item item = ingredient.func_77973_b();
        for (ItemGroup itemGroup : item.getCreativeTabs()) {
            if (itemGroup == null) continue;
            String creativeTabName = I18n.func_135052_a((String)itemGroup.func_78024_c(), (Object[])new Object[0]);
            creativeTabsStrings.add(creativeTabName);
        }
        return creativeTabsStrings;
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }
}

