/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.blocks;

import com.progwml6.ironchest.common.core.IronChestBlocks;
import com.progwml6.ironchest.common.tileentity.CopperChestTileEntity;
import com.progwml6.ironchest.common.tileentity.CrystalChestTileEntity;
import com.progwml6.ironchest.common.tileentity.DiamondChestTileEntity;
import com.progwml6.ironchest.common.tileentity.DirtChestTileEntity;
import com.progwml6.ironchest.common.tileentity.GoldChestTileEntity;
import com.progwml6.ironchest.common.tileentity.IronChestTileEntity;
import com.progwml6.ironchest.common.tileentity.ObsidianChestTileEntity;
import com.progwml6.ironchest.common.tileentity.SilverChestTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public enum ChestType implements IStringSerializable
{
    IRON(54, 9, "iron_chest.png", IronChestTileEntity.class, "ironchest:iron_chest", 184, 222, new ResourceLocation("ironchest", "textures/gui/iron_container.png"), 256, 256),
    GOLD(81, 9, "gold_chest.png", GoldChestTileEntity.class, "ironchest:gold_chest", 184, 276, new ResourceLocation("ironchest", "textures/gui/gold_container.png"), 256, 276),
    DIAMOND(108, 12, "diamond_chest.png", DiamondChestTileEntity.class, "ironchest:diamond_chest", 238, 276, new ResourceLocation("ironchest", "textures/gui/diamond_container.png"), 256, 276),
    COPPER(45, 9, "copper_chest.png", CopperChestTileEntity.class, "ironchest:copper_chest", 184, 204, new ResourceLocation("ironchest", "textures/gui/copper_container.png"), 256, 256),
    SILVER(72, 9, "silver_chest.png", SilverChestTileEntity.class, "ironchest:silver_chest", 184, 258, new ResourceLocation("ironchest", "textures/gui/silver_container.png"), 256, 276),
    CRYSTAL(108, 12, "crystal_chest.png", CrystalChestTileEntity.class, "ironchest:crystal_chest", 238, 276, new ResourceLocation("ironchest", "textures/gui/diamond_container.png"), 256, 276),
    OBSIDIAN(108, 12, "obsidian_chest.png", ObsidianChestTileEntity.class, "ironchest:obsidian_chest", 238, 276, new ResourceLocation("ironchest", "textures/gui/diamond_container.png"), 256, 276),
    DIRTCHEST9000(1, 1, "dirt_chest.png", DirtChestTileEntity.class, "ironchest:dirt_chest", 184, 184, new ResourceLocation("ironchest", "textures/gui/dirt_container.png"), 256, 256),
    WOOD(0, 0, "", null, null, 0, 0, null, 0, 0);

    public static final ChestType[] VALUES;
    public final String name = this.name().toLowerCase();
    public final int size;
    public final int rowLength;
    public final String modelTexture;
    public final Class<? extends TileEntity> clazz;
    public final String itemName;
    public final int xSize;
    public final int ySize;
    public final ResourceLocation guiTexture;
    public final int textureXSize;
    public final int textureYSize;

    private ChestType(int size, int rowLength, String modelTexture, Class<? extends IronChestTileEntity> clazz, String itemName, int xSize, int ySize, ResourceLocation guiTexture, int textureXSize, int textureYSize) {
        this.size = size;
        this.rowLength = rowLength;
        this.modelTexture = modelTexture;
        this.clazz = clazz;
        this.itemName = itemName;
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiTexture = guiTexture;
        this.textureXSize = textureXSize;
        this.textureYSize = textureYSize;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    public static ChestType get(ResourceLocation resourceLocation) {
        switch (resourceLocation.toString()) {
            case "ironchest:iron_chest": {
                return IRON;
            }
            case "ironchest:gold_chest": {
                return GOLD;
            }
            case "ironchest:diamond_chest": {
                return DIAMOND;
            }
            case "ironchest:copper_chest": {
                return COPPER;
            }
            case "ironchest:silver_chest": {
                return SILVER;
            }
            case "ironchest:crystal_chest": {
                return CRYSTAL;
            }
            case "ironchest:obsidian_chest": {
                return OBSIDIAN;
            }
            case "ironchest:dirt_chest": {
                return DIRTCHEST9000;
            }
        }
        return WOOD;
    }

    public static BlockState get(ChestType type) {
        switch (type) {
            case IRON: {
                return IronChestBlocks.ironChestBlock.func_176223_P();
            }
            case GOLD: {
                return IronChestBlocks.goldChestBlock.func_176223_P();
            }
            case DIAMOND: {
                return IronChestBlocks.diamondChestBlock.func_176223_P();
            }
            case COPPER: {
                return IronChestBlocks.copperChestBlock.func_176223_P();
            }
            case SILVER: {
                return IronChestBlocks.silverChestBlock.func_176223_P();
            }
            case CRYSTAL: {
                return IronChestBlocks.crystalChestBlock.func_176223_P();
            }
            case OBSIDIAN: {
                return IronChestBlocks.obsidianChestBlock.func_176223_P();
            }
            case DIRTCHEST9000: {
                return IronChestBlocks.dirtChestBlock.func_176223_P();
            }
        }
        return null;
    }

    public IronChestTileEntity makeEntity() {
        switch (this) {
            case IRON: {
                return new IronChestTileEntity();
            }
            case GOLD: {
                return new GoldChestTileEntity();
            }
            case DIAMOND: {
                return new DiamondChestTileEntity();
            }
            case COPPER: {
                return new CopperChestTileEntity();
            }
            case SILVER: {
                return new SilverChestTileEntity();
            }
            case CRYSTAL: {
                return new CrystalChestTileEntity();
            }
            case OBSIDIAN: {
                return new ObsidianChestTileEntity();
            }
            case DIRTCHEST9000: {
                return new DirtChestTileEntity();
            }
        }
        return null;
    }

    static {
        VALUES = ChestType.values();
    }
}

