/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.util.PlayerSkins;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;

public class GravestoneRenderer
extends TileEntityRenderer<GraveStoneTileEntity> {
    public void render(GraveStoneTileEntity target, double x, double y, double z, float partialTicks, int destroyStage) {
        String name = target.getPlayerName();
        if (name == null || name.isEmpty()) {
            return;
        }
        Direction direction = (Direction)target.func_195044_w().func_177229_b((IProperty)GraveStoneBlock.FACING);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-this.getDirection(direction)), (float)0.0f, (float)1.0f, (float)0.0f);
        FontRenderer renderer = this.func_147498_b();
        if (renderer != null) {
            int textWidth = renderer.func_78256_a(name);
            float textScale = 0.8f / (float)textWidth;
            textScale = Math.min(textScale, 0.02f);
            GlStateManager.translatef((float)(-(textScale * (float)textWidth) / 2.0f), (float)0.3f, (float)0.37f);
            GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
            GlStateManager.depthMask((boolean)false);
            renderer.func_211126_b(name, 0.0f, 0.0f, 0);
            GlStateManager.depthMask((boolean)true);
        }
        GlStateManager.popMatrix();
        boolean render = false;
        BlockState state = target.func_145831_w().func_180495_p(target.func_174877_v().func_177977_b());
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        if (block == null) {
            return;
        }
        if (block.func_220081_d(state, (IBlockReader)target.func_145831_w(), target.func_174877_v().func_177977_b())) {
            render = true;
        }
        if (target.renderHead() && target.getPlayerUUID() != null && !target.getPlayerUUID().isEmpty() && Config.renderSkull && render) {
            try {
                this.renderSkull(x, y, z, target.getPlayerUUID(), target.getPlayerName(), direction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderSkull(double x, double y, double z, String uuid, String name, Direction rotation) {
        HumanoidHeadModel model = new HumanoidHeadModel();
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (uuid != null) {
            try {
                resourcelocation = PlayerSkins.getSkin(UUID.fromString(uuid), name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.func_147499_a(resourcelocation);
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        GlStateManager.translated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.enableAlphaTest();
        GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        float yaw = 26.0f;
        float pitch = -61.0f;
        float scale = 0.0625f;
        GlStateManager.rotatef((float)(180 - this.getDirection(rotation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.14f, (float)-0.18f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        model.func_217104_a(0.0f, 0.0f, 0.0f, yaw, pitch, scale);
        GlStateManager.popMatrix();
    }

    private int getDirection(Direction facing) {
        switch (facing) {
            case EAST: {
                return 270;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
        }
        return 0;
    }
}

