/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<Class, dsb> originalEntityRenderMap = null;
    private static Map<Class, dpe> originalTileEntityRenderMap = null;
    private static Map<brq.a, dhy> originalSkullModelMap = null;

    public static void update() {
        Map<Class, dsb> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<Class, dpe> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map<brq.a, dhy> skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        if (!Config.isCustomEntityModels()) {
            return;
        }
        qv[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            Class entityClass;
            qv loc = locs[i];
            Config.dbg("CustomEntityModel: " + loc.a());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null || (entityClass = rc.getEntityClass()) == null) continue;
            if (rc instanceof dsb) {
                entityRenderMap.put(entityClass, (dsb)rc);
            } else if (rc instanceof dpe) {
                tileEntityRenderMap.put(entityClass, (dpe)rc);
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static Map<Class, dsb> getEntityRenderMap() {
        dsa rm = cyc.u().V();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<Class, dsb>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<Class, dpe> getTileEntityRenderMap() {
        Map tileEntityRenderMap = dpd.a.i;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<Class, dpe>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<brq.a, dhy> getSkullModelMap() {
        HashMap skullModelMap = (HashMap)Reflector.TileEntitySkullRenderer_MODELS.getValue();
        if (skullModelMap == null) {
            Config.warn("Field not found: TileEntitySkullRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap<brq.a, dhy>(skullModelMap);
        }
        return skullModelMap;
    }

    private static qv[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<qv> resourceLocations = new ArrayList<qv>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            qv loc = new qv(path);
            if (!Config.hasResource(loc)) continue;
            resourceLocations.add(loc);
        }
        qv[] locs = resourceLocations.toArray(new qv[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(qv location) {
        try {
            JsonObject jo2 = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo2, location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
        catch (JsonParseException e3) {
            Config.error("" + ((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage());
            return null;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Class entityClass = modelAdapter.getEntityClass();
        CustomEntityModels.checkNull(entityClass, "Entity class not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setEntityClass(entityClass);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        dhy model;
        qv textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            r.setLocationTextureCustom(textureLocation);
        }
        return r;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dhy model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, dhy model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        djv parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.l != null) {
                parent.l.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.m != null) {
                djv[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                List childModels = parent.m;
                Iterator it2 = childModels.iterator();
                while (it2.hasNext()) {
                    djv mr = (djv)it2.next();
                    if (setMrs.contains(mr)) continue;
                    it2.remove();
                }
            }
        }
        parent.b(customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

