/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.item.tool.ScytheType;
import com.lothrazar.cyclic.util.UtilScythe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketScythe {
    private BlockPos pos;
    private ScytheType type;
    private int radius;

    public PacketScythe() {
    }

    public PacketScythe(BlockPos mouseover, ScytheType t, int r) {
        this.pos = mouseover;
        this.type = t;
        this.radius = r;
    }

    public static void handle(PacketScythe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            List<BlockPos> shape = ScytheType.getShape(message.pos, message.radius);
            for (BlockPos posCurrent : shape) {
                UtilScythe.harvestSingle(world, (PlayerEntity)player, posCurrent, message.type);
            }
        });
    }

    public static PacketScythe decode(PacketBuffer buf) {
        PacketScythe p = new PacketScythe();
        p.radius = buf.readInt();
        p.pos = buf.func_179259_c();
        p.type = ScytheType.values()[buf.readInt()];
        return p;
    }

    public static void encode(PacketScythe msg, PacketBuffer buf) {
        buf.writeInt(msg.radius);
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.type.ordinal());
    }
}

