/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.tool;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeverBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LeverRemote
extends ItemBase {
    public LeverRemote(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockPos pointer = UtilNBT.getItemStackBlockPos(stack);
        if (pointer != null) {
            int dimensionTarget = stack.func_196082_o().func_74762_e("LeverDim");
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.RED + UtilChat.blockPosToString(pointer) + " [" + dimensionTarget + "]", new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            playerIn.func_184609_a(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return super.func_195939_a(context);
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        BlockPos pos = context.func_195995_a();
        if (world.func_180495_p(pos).func_177230_c() instanceof LeverBlock) {
            UtilNBT.setItemStackBlockPos(stack, pos);
            UtilNBT.setItemStackNBTVal(stack, "LeverDim", player.field_71093_bK.func_186068_a());
            if (world.field_72995_K) {
                UtilChat.statusMessage(player, this.func_77658_a() + ".saved");
            }
            return ActionResultType.SUCCESS;
        }
        boolean success = false;
        success = this.trigger(stack, world, player);
        if (success) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private boolean trigger(ItemStack stack, World world, PlayerEntity player) {
        BlockPos blockPos = UtilNBT.getItemStackBlockPos(stack);
        if (blockPos == null) {
            if (world.field_72995_K) {
                UtilChat.statusMessage(player, this.func_77658_a() + ".invalid");
            }
            return false;
        }
        int dimensionTarget = stack.func_196082_o().func_74762_e("LeverDim");
        if (dimensionTarget == player.field_71093_bK.func_186068_a()) {
            BlockState blockState = world.func_180495_p(blockPos);
            if (blockState == null || blockState.func_177230_c() != Blocks.field_150442_at) {
                if (world.field_72995_K) {
                    UtilChat.statusMessage(player, this.func_77658_a() + ".invalid");
                }
                return false;
            }
            blockState = world.func_180495_p(blockPos);
            boolean hasPowerHere = (Boolean)blockState.func_177229_b((IProperty)LeverBlock.field_176359_b);
            UtilWorld.toggleLeverPowerState(world, blockPos, blockState);
            UtilChat.statusMessage(player, this.func_77658_a() + ".powered." + hasPowerHere);
            return true;
        }
        return false;
    }
}

