/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.capability;

import com.lothrazar.cyclic.base.CustomEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapabilityItemStack
implements ICapabilityProvider {
    public static final String NBTENERGY = "energy";
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int max;
    private ItemStack stack;

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.max, this.max / 4){

            public int getEnergyStored() {
                if (EnergyCapabilityItemStack.this.stack.func_77942_o()) {
                    return EnergyCapabilityItemStack.this.stack.func_77978_p().func_74762_e(EnergyCapabilityItemStack.NBTENERGY);
                }
                return super.getEnergyStored();
            }

            @Override
            public void setEnergy(int energy) {
                if (!EnergyCapabilityItemStack.this.stack.func_77942_o()) {
                    EnergyCapabilityItemStack.this.stack.func_77982_d(new CompoundNBT());
                }
                EnergyCapabilityItemStack.this.stack.func_77978_p().func_74768_a(EnergyCapabilityItemStack.NBTENERGY, energy);
                super.setEnergy(energy);
            }
        };
    }

    public EnergyCapabilityItemStack(ItemStack stack, int capacity) {
        this.max = capacity;
        this.stack = stack;
        this.energy = LazyOptional.of(this::createEnergy);
    }

    public String toString() {
        return "EnergyCapabilityItemStack [energy=" + this.energy + ", max=" + this.max + "]";
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }
}

