/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.tank.TileTank;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockFluidTank
extends BlockBase {
    public static final BooleanProperty TANK_ABOVE = BooleanProperty.func_177716_a((String)"above");
    public static final BooleanProperty TANK_BELOW = BooleanProperty.func_177716_a((String)"below");
    public static final int heightCheckMax = 16;

    public BlockFluidTank(Block.Properties properties) {
        super(properties.harvestTool(ToolType.PICKAXE).func_200943_b(1.2f));
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockRenderType func_149645_b(BlockState s) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        TileEntity tileEntity = reader.func_175625_s(pos);
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileTank();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        IFluidHandler handler;
        TileEntity tankHere;
        if (!world.field_72995_K && (tankHere = world.func_175625_s(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElse(null)) != null && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler)) {
            if (handler.getFluidInTank(0) != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("" + handler.getFluidInTank(0).getAmount(), new Object[0]), true);
            }
            if (player instanceof ServerPlayerEntity) {
                UtilSound.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187630_M);
            }
        }
        if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, hit);
    }
}

