/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.lothrazar.cyclic.CyclicRegistry;
import com.lothrazar.cyclic.block.scaffolding.ItemScaffolding;
import com.lothrazar.cyclic.event.EventHandler;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.setup.ClientProxy;
import com.lothrazar.cyclic.setup.ConfigHandler;
import com.lothrazar.cyclic.setup.IProxy;
import com.lothrazar.cyclic.setup.ServerProxy;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

@Mod(value="cyclic")
public class ModCyclic {
    public static final String certificateFingerprint = "@FINGERPRINT@";
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static final String MODID = "cyclic";
    public static final Logger LOGGER = LogManager.getLogger();
    ItemScaffolding[] scaffoldingListen = new ItemScaffolding[0];

    public ModCyclic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        ConfigHandler.loadConfig(ConfigHandler.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("cyclic.toml"));
    }

    private void setup(FMLCommonSetupEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("charm").setSize(2).setEnabled(true).setHidden(false));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("necklace").setSize(1).setEnabled(true).setHidden(false));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("hands").setSize(2).setEnabled(true).setHidden(false));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("belt").setSize(2).setEnabled(true).setHidden(false));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("ring").setSize(2).setEnabled(true).setHidden(false));
        PacketRegistry.init();
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Blocks.soundproofing);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.excavate);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.experience_boost);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.life_leech);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.magnet);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.multishot);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.quickshot);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.launch);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.step);
        MinecraftForge.EVENT_BUS.register((Object)CyclicRegistry.Enchants.venom);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.scaffoldingListen = new ItemScaffolding[]{CyclicRegistry.Items.item_scaffold_fragile, CyclicRegistry.Items.item_scaffold_responsive, CyclicRegistry.Items.item_scaffold_replace};
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        for (ItemScaffolding loop : this.scaffoldingListen) {
            if (event.getItemStack() == null || event.getItemStack().func_77973_b() != loop || !event.getPlayer().func_70093_af()) continue;
            Direction opp = event.getFace().func_176734_d();
            BlockPos dest = UtilWorld.nextReplaceableInDirection(event.getWorld(), event.getPos(), opp, 16, loop.func_179223_d());
            event.getWorld().func_175656_a(dest, Block.func_149634_a((Item)loop).func_176223_P());
            ItemStack stac = event.getPlayer().func_184586_b(event.getHand());
            stac.func_190918_g(1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "cyclicInvalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
    }
}

